/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.admin.property.uddi.VWConfigUDDIListTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWConfigUDDIListPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWUDDIPanelOperation {
    private VWUDDIRegistryList m_uddiRegistryList = null;
    private JDialog m_parentDialog = null;
    private boolean m_bAllowUserEnterWSDL = false;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_UDDIRegistriesTable = null;
    private VWConfigUDDIListTableModel m_tableModel = null;
    private JCheckBox m_allowUserEnterWSDLCheckBox = null;

    public VWConfigUDDIListPanel(JDialog parentDialog, VWUDDIRegistryList uddiRegistryList) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_uddiRegistryList = uddiRegistryList;
            this.m_bAllowUserEnterWSDL = this.m_uddiRegistryList.getAllowUserEnterWSDL();
            this.createControls(parentDialog);
            this.m_UDDIRegistriesTable.clearSelection();
            if (this.m_UDDIRegistriesTable.getRowCount() > 0) {
                this.m_UDDIRegistriesTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x100000));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        this.stopEditing();
        if (this.m_allowUserEnterWSDLCheckBox.isSelected() != this.m_bAllowUserEnterWSDL) {
            return true;
        }
        return this.m_tableModel.hasChanged();
    }

    public boolean validateData() {
        boolean bSuccess = true;
        if (this.m_tableModel.hasChanged()) {
            bSuccess = this.m_tableModel.verifyUDDIRegistries();
        }
        return bSuccess;
    }

    public void stopEditing() {
        if (this.m_UDDIRegistriesTable != null) {
            this.m_UDDIRegistriesTable.stopEditing();
        }
    }

    public void getUpdatedUDDIRegistry() {
        try {
            this.stopEditing();
            if (this.hasChanged()) {
                VWUDDIRegistry[] uddiRegistries = this.m_tableModel.getUDDIRegistries();
                this.m_uddiRegistryList.setAllowUserEnterWSDL(this.m_allowUserEnterWSDLCheckBox.isSelected());
                this.m_uddiRegistryList.setUDDIRegistries(uddiRegistries);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            if (this.hasChanged() && (bSuccess = this.m_tableModel.verifyUDDIRegistries())) {
                VWUDDIRegistry[] uddiRegistries = this.m_tableModel.getUDDIRegistries();
                this.m_uddiRegistryList.setAllowUserEnterWSDL(this.m_allowUserEnterWSDLCheckBox.isSelected());
                this.m_uddiRegistryList.setUDDIRegistries(uddiRegistries);
                this.m_uddiRegistryList.updateAttribute();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public void releaseResources() {
        if (this.m_uddiRegistryList != null) {
            this.m_uddiRegistryList.releaseResources();
            this.m_uddiRegistryList = null;
        }
        this.m_parentDialog = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_UDDIRegistriesTable != null) {
            this.m_UDDIRegistriesTable.removeAll();
            this.m_UDDIRegistriesTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_allowUserEnterWSDLCheckBox != null) {
            this.m_allowUserEnterWSDLCheckBox.removeAll();
            this.m_allowUserEnterWSDLCheckBox = null;
        }
        this.removeAll();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_UDDIRegistriesTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_UDDIRegistriesTable.getSelectedRow()) {
                    this.m_UDDIRegistriesTable.clearSelection();
                }
                this.m_UDDIRegistriesTable.setRowSelectionInterval(nRow, nRow);
                this.m_UDDIRegistriesTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_UDDIRegistriesTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_UDDIRegistriesTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex < 0 || nLastIndex < 0) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x100000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x100000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_UDDIRegistriesTable.setRowSelectionInterval(nRow, nRow);
                    this.m_UDDIRegistriesTable.setColumnSelectionInterval(0, 0);
                    this.m_UDDIRegistriesTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 0x100000: {
                    this.onValidateRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean allowUserEnterWSDL() {
        return this.m_allowUserEnterWSDLCheckBox.isSelected();
    }

    private void createControls(JDialog parentDialog) {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createUDDIRegistriesPanel(parentDialog);
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createUDDIRegistriesPanel(JDialog parentDialog) {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.UDDIRegistryList, 0x10100010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigUDDIListTableModel(parentDialog, this.m_uddiRegistryList.getUDDIRegistries());
            this.m_tableModel.addTableModelListener(this);
            this.m_UDDIRegistriesTable = new VWTable(this.m_tableModel);
            this.m_UDDIRegistriesTable.setRowSelectionAllowed(true);
            this.m_UDDIRegistriesTable.getSelectionModel().addListSelectionListener(this);
            this.m_UDDIRegistriesTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            this.m_UDDIRegistriesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_UDDIRegistriesTable), "Center");
            this.m_allowUserEnterWSDLCheckBox = new JCheckBox(VWResource.EnableEnteringWSDL);
            this.m_allowUserEnterWSDLCheckBox.setSelected(this.m_uddiRegistryList.getAllowUserEnterWSDL());
            panel.add((Component)this.m_allowUserEnterWSDLCheckBox, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        try {
            this.stopEditing();
            int[] rows = this.m_UDDIRegistriesTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onValidateRows() {
        try {
            this.stopEditing();
            int[] rows = this.m_UDDIRegistriesTable.getSelectedRows();
            for (int nIndex = 0; nIndex < rows.length; ++nIndex) {
                this.m_tableModel.validateRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

